'use strict';

/* --------------------------------------------------------------
   password_option.js 2025-08-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2025 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

gambio.widgets.module('password_option', [], function (data) {

	'use strict';

	var $this = $(this),
	    $body = $('body'),
	    $password_inputs = $('div.password-inputs'),
	    defaults = {},
	    options = $.extend(true, {}, defaults, data),
	    module = {};

	// ########## HELPER FUNCTIONS ##########

	// (none)

	// ########## INITIALIZATION ##########

	/**
  * Init function of the widget
  * @constructor
  */
	module.init = function (done) {
		var $passwordOption = $('#password-option');

		$passwordOption.on('change', function () {
			var isChecked = $(this).get(0).checked,
			    $passwordInputs = $('div.password-inputs input[type="password"]');
			if (isChecked) {
				$password_inputs.show();
				$passwordInputs.each(function () {
					$(this).removeAttr('disabled');
				});
				$('button[type="submit"]', $this.closest('form')).attr('disabled', 'disabled');
			} else {
				$password_inputs.hide();
				$passwordInputs.each(function () {
					$(this).attr('disabled', 'disabled');
					$(this).val('');
				});
				$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
			}
		});

		var passwordChange = function passwordChange() {
			var isChecked = $passwordOption.get(0) !== undefined ? $passwordOption.get(0).checked : true;
			if (isChecked) {
				var inputsMatch = $('#password').val().length >= 0 && $('#password').val() === $('#confirmation').val(),
				    $noMatchNote = $('span.password-no-match');

				if (inputsMatch) {
					$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
					$password_inputs.removeClass('has-error');
					$noMatchNote.hide();
				} else {
					$('button[type="submit"]', $this.closest('form')).attr('disabled', 'disabled');
					$password_inputs.addClass('has-error');
					$noMatchNote.show();
				}
			}
		};

		var switchPasswordOption = function switchPasswordOption(e) {
			if (e.code === 'Space') {
				var isChecked = $passwordOption.get(0) !== undefined ? $passwordOption.get(0).checked : true;
				if (isChecked) {
					$passwordOption.prop('checked', false);
				} else {
					$passwordOption.prop('checked', true);
				}
				$passwordOption.trigger('change');
			}
		};

		$('#password, #confirmation').on('input', passwordChange);
		$passwordOption.on('keypress', switchPasswordOption);
		$passwordOption.trigger('change');

		done();
	};

	// Return data to widget engine
	return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
